/*
 * Decompiled with CFR 0.152.
 */
package org.retentionprediction;

import java.util.Arrays;
import java.util.Comparator;

class InterpolationFunction {
    public double[][] dInterpolationParameters;
    public double[] dRanges;

    public InterpolationFunction(double[][] dataPoints) {
        DataPointComparator byXVal = new DataPointComparator();
        Arrays.sort(dataPoints, byXVal);
        int m = (dataPoints.length - 1) * 4;
        int n = (dataPoints.length - 1) * 4;
        double[][] dMatrix = new double[n][m + 1];
        int iRowPos = 0;
        int i = 0;
        while (i < dataPoints.length - 1) {
            dMatrix[iRowPos][i * 4] = 1.0;
            dMatrix[iRowPos + 1][i * 4] = 1.0;
            dMatrix[iRowPos][i * 4 + 1] = dataPoints[i][0];
            dMatrix[iRowPos + 1][i * 4 + 1] = dataPoints[i + 1][0];
            dMatrix[iRowPos][i * 4 + 2] = Math.pow(dataPoints[i][0], 2.0);
            dMatrix[iRowPos + 1][i * 4 + 2] = Math.pow(dataPoints[i + 1][0], 2.0);
            dMatrix[iRowPos][i * 4 + 3] = Math.pow(dataPoints[i][0], 3.0);
            dMatrix[iRowPos + 1][i * 4 + 3] = Math.pow(dataPoints[i + 1][0], 3.0);
            dMatrix[iRowPos][n] = dataPoints[i][1];
            dMatrix[iRowPos + 1][n] = dataPoints[i + 1][1];
            iRowPos += 2;
            ++i;
        }
        i = 0;
        while (i < dataPoints.length - 2) {
            dMatrix[iRowPos][i * 4 + 1] = 1.0;
            dMatrix[iRowPos][i * 4 + 2] = 2.0 * dataPoints[i + 1][0];
            dMatrix[iRowPos][i * 4 + 3] = 3.0 * Math.pow(dataPoints[i + 1][0], 2.0);
            dMatrix[iRowPos][i * 4 + 5] = -1.0;
            dMatrix[iRowPos][i * 4 + 6] = -2.0 * dataPoints[i + 1][0];
            dMatrix[iRowPos][i * 4 + 7] = -3.0 * Math.pow(dataPoints[i + 1][0], 2.0);
            ++iRowPos;
            ++i;
        }
        i = 0;
        while (i < dataPoints.length - 2) {
            dMatrix[iRowPos][i * 4 + 2] = 2.0;
            dMatrix[iRowPos][i * 4 + 3] = 6.0 * dataPoints[i + 1][0];
            dMatrix[iRowPos][i * 4 + 6] = -2.0;
            dMatrix[iRowPos][i * 4 + 7] = -6.0 * dataPoints[i + 1][0];
            ++iRowPos;
            ++i;
        }
        dMatrix[iRowPos][2] = 2.0;
        dMatrix[iRowPos][3] = 6.0 * dataPoints[0][0];
        dMatrix[iRowPos][6] = -2.0;
        dMatrix[iRowPos][7] = -6.0 * dataPoints[1][0];
        dMatrix[++iRowPos][(dataPoints.length - 2) * 4 + 2] = 2.0;
        dMatrix[iRowPos][(dataPoints.length - 2) * 4 + 3] = 6.0 * dataPoints[dataPoints.length - 1][0];
        dMatrix[iRowPos][(dataPoints.length - 3) * 4 + 2] = -2.0;
        dMatrix[iRowPos][(dataPoints.length - 3) * 4 + 3] = -6.0 * dataPoints[dataPoints.length - 2][0];
        i = 0;
        int j = 0;
        while (i < n && j < m) {
            int k = i;
            while (k < n && dMatrix[k][j] == 0.0) {
                ++k;
            }
            if (k < n) {
                if (k != i) {
                    InterpolationFunction.swap(dMatrix, i, k, j);
                }
                if (dMatrix[i][j] != 1.0) {
                    InterpolationFunction.divide(dMatrix, i, j);
                }
                InterpolationFunction.eliminate(dMatrix, i, j);
                ++i;
            }
            ++j;
        }
        this.dRanges = new double[dataPoints.length - 2];
        this.dInterpolationParameters = new double[dataPoints.length - 1][4];
        i = 0;
        while (i < this.dInterpolationParameters.length) {
            this.dInterpolationParameters[i][0] = dMatrix[i * 4][m];
            this.dInterpolationParameters[i][1] = dMatrix[i * 4 + 1][m];
            this.dInterpolationParameters[i][2] = dMatrix[i * 4 + 2][m];
            this.dInterpolationParameters[i][3] = dMatrix[i * 4 + 3][m];
            ++i;
        }
        i = 0;
        while (i < this.dRanges.length) {
            this.dRanges[i] = dataPoints[i + 1][0];
            ++i;
        }
    }

    public double getAt(double x) {
        int i = 0;
        while (x > this.dRanges[i]) {
            if (++i >= this.dRanges.length) break;
        }
        double y = this.dInterpolationParameters[i][0] + this.dInterpolationParameters[i][1] * x + this.dInterpolationParameters[i][2] * Math.pow(x, 2.0) + this.dInterpolationParameters[i][3] * Math.pow(x, 3.0);
        return y;
    }

    static void swap(double[][] A, int i, int k, int j) {
        int m = A[0].length - 1;
        int q = j;
        while (q <= m) {
            double temp = A[i][q];
            A[i][q] = A[k][q];
            A[k][q] = temp;
            ++q;
        }
    }

    static void divide(double[][] A, int i, int j) {
        int m = A[0].length - 1;
        int q = j + 1;
        while (q <= m) {
            double[] dArray = A[i];
            int n = q++;
            dArray[n] = dArray[n] / A[i][j];
        }
        A[i][j] = 1.0;
    }

    static void eliminate(double[][] A, int i, int j) {
        int n = A.length;
        int m = A[0].length - 1;
        int p = 0;
        while (p < n) {
            if (p != i && A[p][j] != 0.0) {
                int q = j + 1;
                while (q <= m) {
                    double[] dArray = A[p];
                    int n2 = q;
                    dArray[n2] = dArray[n2] - A[p][j] * A[i][q];
                    ++q;
                }
                A[p][j] = 0.0;
            }
            ++p;
        }
    }

    class DataPointComparator
    implements Comparator<double[]> {
        DataPointComparator() {
        }

        @Override
        public int compare(double[] arg0, double[] arg1) {
            if (arg0[0] > arg1[0]) {
                return 1;
            }
            if (arg0[0] < arg1[0]) {
                return -1;
            }
            return 0;
        }
    }
}

